# 📋 ОТЧЁТ О СОЗДАНИИ ВЕБ-ПРЕЗЕНТАЦИИ-ГЛОССАРИЯ  
## «Гибкая методология SCRUM в образовательном процессе»

GitHub репозиторий: [Ссылка на репозиторий](https://github.com/NewSarcasmProvider/Web--based-slideshow/tree/main?tab=readme-ov-file)
Live демо: [Ссылка на GitHub Pages](https://newsarcasmprovider.github.io/Web--based-slideshow/)

---

## 1. Общая характеристика работы

**Тема работы:**  
Создание презентации-глоссария на тему  
«Гибкая методология SCRUM в образовательном процессе»  
с использованием веб-технологий HTML, CSS, JavaScript  
и публикацией в сети Интернет через GitHub Pages.

**Цель работы:**  
Разработка веб-ориентированной презентации-глоссария, предназначенной для изучения ключевых понятий методологии SCRUM в образовательном контексте, с возможностью интерактивной навигации и дальнейшего расширения функциональности.

**Задачи работы:**
- проанализировать содержание методологии SCRUM с точки зрения образовательного применения;
- отобрать и структурировать ключевые термины;
- реализовать веб-презентацию в формате слайд-шоу;
- обеспечить удобную навигацию между слайдами;
- опубликовать готовый продукт с использованием сервиса GitHub Pages.

---

## 2. Обоснование выбора формата и технологий

### Выбор формата веб-презентации

Формат **web-based slideshow** был выбран как альтернатива традиционным презентациям (PowerPoint, PDF), поскольку он:
- обеспечивает доступ через браузер без установки дополнительного ПО;
- поддерживает интерактивность;
- легко адаптируется под разные устройства;
- позволяет интегрировать JavaScript-логику.

Формат глоссария способствует систематизации терминов и формированию понятийного аппарата обучающихся.

### Используемые технологии

В ходе работы применялись следующие веб-технологии:
- **HTML5** — структурирование контента и слайдов;
- **CSS3** — визуальное оформление и адаптивный дизайн;
- **JavaScript (ES6)** — логика навигации и управления слайдами;
- **GitHub Pages** — хостинг и публикация веб-сайта.

Выбранный стек технологий не требует серверной части и полностью подходит для образовательных проектов.

---

## 3. Проектирование структуры презентации-глоссария

### Содержательная структура

Презентация включает **10 тематических слайдов**, каждый из которых посвящён отдельному понятию SCRUM.

Такое распределение материала обеспечивает логичное и последовательное изучение темы.

### Навигационная структура

Реализована линейная навигация:
- переход к следующему и предыдущему слайду;
- визуальное выделение активного слайда;
- возможность масштабирования структуры в будущем.

---

## 4. Реализация веб-презентации

### HTML-реализация

Каждый слайд реализован как отдельный логический блок.  
Контент включает:
- заголовок термина;
- краткое определение;
- пояснение в образовательном контексте.

Семантическая разметка повышает читаемость кода и доступность сайта.

### CSS-оформление

Визуальное оформление выполнено с акцентом на:
- минимализм;
- читаемость текста;
- контрастность элементов;
- адаптацию под разные размеры экранов.

Использованы современные возможности CSS:
- flexbox;
- медиазапросы;
- плавные переходы.

### JavaScript-логика

JavaScript используется для:
- управления переключением слайдов;
- обработки пользовательских действий;
- синхронизации состояния интерфейса.

Логика реализована без сторонних библиотек, что повышает прозрачность и обучающую ценность проекта.

---

## 5. Публикация проекта с использованием GitHub Pages

Для размещения проекта был использован сервис **GitHub Pages**, который позволяет публиковать статические сайты напрямую из репозитория.

### Этапы публикации:
1. создание репозитория на GitHub;
2. загрузка файлов проекта (HTML, CSS, JS);
3. настройка ветки `main` в качестве источника публикации;
4. получение публичного URL веб-сайта.

Использование GitHub Pages обеспечивает:
- бесплатный хостинг;
- доступность проекта в сети Интернет;
- возможность демонстрации результата преподавателю или аудитории.

---

## 6. Результаты выполнения работы

В результате выполнения работы:
- создан веб-сайт в формате презентации-глоссария;
- реализована удобная навигация между слайдами;
- обеспечена адаптивность интерфейса;
- материал структурирован и доступен для самостоятельного изучения;
- проект успешно опубликован через GitHub Pages.

Созданный ресурс может использоваться как:
- учебное пособие;
- вспомогательный материал на занятиях;
- основа для дальнейшего развития образовательного продукта.

---

## 7. Выводы

Создание презентации-глоссария средствами веб-технологий продемонстрировало эффективность использования HTML, CSS и JavaScript для разработки образовательных ресурсов. Формат web-based slideshow является современным и удобным инструментом представления учебного материала.

Публикация проекта через GitHub Pages обеспечивает его открытость и практическую применимость в образовательном процессе. Полученный результат соответствует поставленной цели и может быть масштабирован за счёт добавления интерактивных элементов и новых разделов.

---
